import { IUserRepository, User } from "../interfaces/user.interface";
import { UserRepositoryPrisma } from "../repositories/user.repository";

class UserUseCase {
    private userRepository: IUserRepository;
    constructor() {
        this.userRepository = new UserRepositoryPrisma();
    }

    async findByEmail({ email }: { email: string }): Promise<User | null> {
        const result = await this.userRepository.findByEmail(email);
        return result as any;
    }

    async findById({ id }: { id: number }): Promise<User | null> {
        const result = await this.userRepository.findById(id);
        return result as any;
    }

    async updateUser(data: User): Promise<User> {
        const result = await this.userRepository.update(data);
        return result as any;
    }

    async deleteUser({ id }: { id: number }): Promise<void> {
        await this.userRepository.delete(id);
    }
};

export { UserUseCase };