"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserUseCase = void 0;
const user_repository_1 = require("../repositories/user.repository");
class UserUseCase {
    constructor() {
        this.userRepository = new user_repository_1.UserRepositoryPrisma();
    }
    async findByEmail({ email }) {
        const result = await this.userRepository.findByEmail(email);
        return result;
    }
    async findById({ id }) {
        const result = await this.userRepository.findById(id);
        return result;
    }
    async updateUser(data) {
        const result = await this.userRepository.update(data);
        return result;
    }
    async deleteUser({ id }) {
        await this.userRepository.delete(id);
    }
}
exports.UserUseCase = UserUseCase;
;
