import { ISubCategoriaRepository, Subcategoria } from "../interfaces/subcategoria.interfaces";
import SubCategoriaRepositoryPrisma from "../repositories/subcategoria.repository";

class SubCategoriaUseCase {
    private subcategoriaRepository: ISubCategoriaRepository;
    constructor() {
        this.subcategoriaRepository = new SubCategoriaRepositoryPrisma();
    }

    async create({ nome, descricao, categoria_id }: Subcategoria): Promise<Subcategoria> {
        const result = await this.subcategoriaRepository.create({ nome, descricao, categoria_id });
        return result;
    }

    async findAll(): Promise<Subcategoria[]> {
        const result = await this.subcategoriaRepository.findAll();
        return result;
    }

    async findById(id: number): Promise<Subcategoria | null> {
        const result = await this.subcategoriaRepository.findById(id);
        return result;
    }

    async update(data: Subcategoria): Promise<Subcategoria> {
        const result = await this.subcategoriaRepository.update(data);
        return result;
    }

    async delete(id: number): Promise<void> {
        await this.subcategoriaRepository.delete(id);
    }
};

export default SubCategoriaUseCase;