"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const subcategoria_repository_1 = __importDefault(require("../repositories/subcategoria.repository"));
class SubCategoriaUseCase {
    constructor() {
        this.subcategoriaRepository = new subcategoria_repository_1.default();
    }
    async create({ nome, descricao, categoria_id }) {
        const result = await this.subcategoriaRepository.create({ nome, descricao, categoria_id });
        return result;
    }
    async findAll() {
        const result = await this.subcategoriaRepository.findAll();
        return result;
    }
    async findById(id) {
        const result = await this.subcategoriaRepository.findById(id);
        return result;
    }
    async update(data) {
        const result = await this.subcategoriaRepository.update(data);
        return result;
    }
    async delete(id) {
        await this.subcategoriaRepository.delete(id);
    }
}
;
exports.default = SubCategoriaUseCase;
