import { IPerguntaRepository, Pergunta } from "../interfaces/pergunta.interfaces";
import { PerguntaRepositoryPrisma } from "../repositories/pergunta.repository";

class PerguntaUseCase {
    private perguntaRepository: IPerguntaRepository;
    constructor() {
        this.perguntaRepository = new PerguntaRepositoryPrisma();
    }

    async create({ texto, subcategoria_id }: Pergunta): Promise<Pergunta> {
        const result = await this.perguntaRepository.create({ texto, subcategoria_id });
        return result;
    }

    async findAll(): Promise<Pergunta[]> {
        const result = await this.perguntaRepository.findAll();
        return result;
    }

    async findById(id: number): Promise<Pergunta | null> {
        const result = await this.perguntaRepository.findById(id);
        return result;
    }

    async update({ id, texto, subcategoria_id }: Pergunta): Promise<Pergunta> {
        const result = await this.perguntaRepository.update({ id, texto, subcategoria_id });
        return result;
    }

    async delete(id: number): Promise<void> {
        await this.perguntaRepository.delete(id);
    }
};

export default PerguntaUseCase;