import { Categoria, ICategoriaRepository } from "../interfaces/categoria.interfaces";
import CategoriaRepositoryPrisma from "../repositories/categoria.repository";

class CategoriaUseCase {
    private categoriaRepository: ICategoriaRepository;
    constructor() {
        this.categoriaRepository = new CategoriaRepositoryPrisma();
    }

    async create({ nome, descricao }: Categoria): Promise<Categoria> {
        const result = await this.categoriaRepository.create({ nome, descricao });
        return result;
    }

    async findAll(): Promise<Categoria[]> {
        const result = await this.categoriaRepository.findAll();
        return result;
    }

    async findById(id: number): Promise<Categoria | null> {
        const result = await this.categoriaRepository.findById(id);
        return result;
    }

    async update(data: Categoria): Promise<Categoria> {
        const result = await this.categoriaRepository.update(data);
        return result;
    }

    async delete(id: number): Promise<void> {
        await this.categoriaRepository.delete(id);
    }
};

export default CategoriaUseCase;