"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const categoria_repository_1 = __importDefault(require("../repositories/categoria.repository"));
class CategoriaUseCase {
    constructor() {
        this.categoriaRepository = new categoria_repository_1.default();
    }
    async create({ nome, descricao }) {
        const result = await this.categoriaRepository.create({ nome, descricao });
        return result;
    }
    async findAll() {
        const result = await this.categoriaRepository.findAll();
        return result;
    }
    async findById(id) {
        const result = await this.categoriaRepository.findById(id);
        return result;
    }
    async update(data) {
        const result = await this.categoriaRepository.update(data);
        return result;
    }
    async delete(id) {
        await this.categoriaRepository.delete(id);
    }
}
;
exports.default = CategoriaUseCase;
