import { IAuthRepository, IResetPassword, IUser, UserCreate } from "../interfaces/auth.interfaces";
import { AuthRepositoryPrisma } from "../repositories/auth.repository";

class AuthUserCase {
    private authRepository: IAuthRepository;
    constructor() {
        this.authRepository = new AuthRepositoryPrisma();
    }

    async create({ email, password, role, cliente, profissional }: UserCreate): Promise<IUser> {
        const result = await this.authRepository.create({ email, password, role, cliente, profissional });
        return result;
    }

    async login({ email, password }: UserCreate): Promise<IUser> {
        const result = await this.authRepository.login({ email, password });
        return result as never;
    }

    async forgotPassword({ email }: { email: string }): Promise<void> {
        const result = await this.authRepository.forgotPassword(email);
        return result;
    }

    async resetPassword({ email, token, password }: IResetPassword): Promise<void> {
        const result = await this.authRepository.resetPassword({ email, token, password });
        return result;
    }
};

export { AuthUserCase };