"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthUserCase = void 0;
const auth_repository_1 = require("../repositories/auth.repository");
class AuthUserCase {
    constructor() {
        this.authRepository = new auth_repository_1.AuthRepositoryPrisma();
    }
    async create({ email, password, role, cliente, profissional }) {
        const result = await this.authRepository.create({ email, password, role, cliente, profissional });
        return result;
    }
    async login({ email, password }) {
        const result = await this.authRepository.login({ email, password });
        return result;
    }
    async forgotPassword({ email }) {
        const result = await this.authRepository.forgotPassword(email);
        return result;
    }
    async resetPassword({ email, token, password }) {
        const result = await this.authRepository.resetPassword({ email, token, password });
        return result;
    }
}
exports.AuthUserCase = AuthUserCase;
;
