import { Subcategoria } from './../interfaces/subcategoria.interfaces';
import { FastifyInstance } from "fastify";
import SubcategoriaUseCase from "../userCases/subcategoria.usercases";
import { authMiddleware } from '../middlewares/auth.middleware';

export async function subcategoriaRoutes(fastify: FastifyInstance) {
    const subcategoriaUseCase = new SubcategoriaUseCase();

    fastify.post<{ Body: Subcategoria }>('/register', { preHandler: authMiddleware as any }, async (req, reply) => {
        const { nome, descricao, categoria_id } = req.body
        try {
            const data = await subcategoriaUseCase.create({ nome, descricao, categoria_id })
            return reply.send({ message: "Registro realizado com sucesso", data });
        } catch (error) {
            reply.status(500).send(error)
        }
    })

    fastify.get('/all', async (req, reply) => {
        try {
            const data = await subcategoriaUseCase.findAll()
            return reply.send(data);
        } catch (error) {
            reply.status(500).send(error)
        }
    })

    fastify.get<{ Params: { id: number } }>('/:id', async (req, reply) => {
        const { id } = req.params
        try {
            const data = await subcategoriaUseCase.findById(Number(id))
            return reply.send(data);
        } catch (error) {
            reply.status(500).send(error)
        }
    })

    fastify.put<{ Body: Subcategoria }>('/update', { preHandler: authMiddleware as any }, async (req, reply) => {
        const { id, nome, descricao, categoria_id } = req.body
        try {
            const data = await subcategoriaUseCase.update({ id, nome, descricao, categoria_id })
            return reply.send({ message: "Registro atualizado com sucesso", data });
        } catch (error) {
            reply.status(500).send(error)
        }
    })

    fastify.delete<{ Params: { id: number } }>('/:id', { preHandler: authMiddleware as any }, async (req, reply) => {
        const { id } = req.params
        try {
            await subcategoriaUseCase.delete(Number(id))
            return reply.send({ message: "Registro deletado com sucesso" });
        } catch (error) {
            reply.status(500).send(error)
        }
    })
};