"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.subcategoriaRoutes = subcategoriaRoutes;
const subcategoria_usercases_1 = __importDefault(require("../userCases/subcategoria.usercases"));
const auth_middleware_1 = require("../middlewares/auth.middleware");
async function subcategoriaRoutes(fastify) {
    const subcategoriaUseCase = new subcategoria_usercases_1.default();
    fastify.post('/register', { preHandler: auth_middleware_1.authMiddleware }, async (req, reply) => {
        const { nome, descricao, categoria_id } = req.body;
        try {
            const data = await subcategoriaUseCase.create({ nome, descricao, categoria_id });
            return reply.send({ message: "Registro realizado com sucesso", data });
        }
        catch (error) {
            reply.status(500).send(error);
        }
    });
    fastify.get('/all', async (req, reply) => {
        try {
            const data = await subcategoriaUseCase.findAll();
            return reply.send(data);
        }
        catch (error) {
            reply.status(500).send(error);
        }
    });
    fastify.get('/:id', async (req, reply) => {
        const { id } = req.params;
        try {
            const data = await subcategoriaUseCase.findById(Number(id));
            return reply.send(data);
        }
        catch (error) {
            reply.status(500).send(error);
        }
    });
    fastify.put('/update', { preHandler: auth_middleware_1.authMiddleware }, async (req, reply) => {
        const { id, nome, descricao, categoria_id } = req.body;
        try {
            const data = await subcategoriaUseCase.update({ id, nome, descricao, categoria_id });
            return reply.send({ message: "Registro atualizado com sucesso", data });
        }
        catch (error) {
            reply.status(500).send(error);
        }
    });
    fastify.delete('/:id', { preHandler: auth_middleware_1.authMiddleware }, async (req, reply) => {
        const { id } = req.params;
        try {
            await subcategoriaUseCase.delete(Number(id));
            return reply.send({ message: "Registro deletado com sucesso" });
        }
        catch (error) {
            reply.status(500).send(error);
        }
    });
}
;
