import { FastifyInstance } from "fastify";
import PerguntaUseCase from "../userCases/pergunta.usercases";
import { Pergunta } from "../interfaces/pergunta.interfaces";
import { authMiddleware } from "../middlewares/auth.middleware";

export async function perguntaRoutes(fastify: FastifyInstance) {
    const perguntaUserCase = new PerguntaUseCase();

    fastify.post<{ Body: Pergunta }>('/register', { preHandler: authMiddleware as any }, async (req, reply) => {
        const { texto, subcategoria_id } = req.body
        try {
            const data = await perguntaUserCase.create({ texto, subcategoria_id })
            return reply.send({ message: "Registro realizado com sucesso", data });
        } catch (error) {
            reply.status(500).send(error)
        }
    })

    fastify.get('/', async (req, reply) => {
        try {
            const data = await perguntaUserCase.findAll()
            return reply.send(data);
        } catch (error) {
            reply.status(500).send(error)
        }
    })

    fastify.get<{ Params: { id: number } }>('/:id', async (req, reply) => {
        const id = req.headers['id'] as unknown as number;
        try {
            const data = await perguntaUserCase.findById(id)
            return reply.send(data);
        } catch (error) {
            console.log(error);
            reply.status(500).send(error)
        }
    })

    fastify.put<{ Body: Pergunta }>('/update', { preHandler: authMiddleware as any }, async (req, reply) => {
        const { id, texto, subcategoria_id } = req.body
        try {
            const data = await perguntaUserCase.update({ id, texto, subcategoria_id })
            return reply.send({ message: "Registro atualizado com sucesso", data });
        } catch (error) {
            reply.status(500).send(error)
        }
    })

    fastify.delete<{ Params: { id: number } }>('/delete/:id', { preHandler: authMiddleware as any }, async (req, reply) => {
        const { id } = req.params
        try {
            await perguntaUserCase.delete(id)
            return reply.send({ message: "Registro deletado com sucesso" });
        } catch (error) {
            reply.status(500).send(error)
        }
    })

}