"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.categoriaRoutes = categoriaRoutes;
const categoria_usercases_1 = __importDefault(require("../userCases/categoria.usercases"));
const auth_middleware_1 = require("../middlewares/auth.middleware");
const zod_1 = require("zod");
async function categoriaRoutes(fastify) {
    const categoriaUserCase = new categoria_usercases_1.default();
    fastify.post('/register', { preHandler: auth_middleware_1.authMiddleware }, async (req, reply) => {
        const createCategoriaSchema = zod_1.z.object({
            nome: zod_1.z.string(),
            descricao: zod_1.z.string(),
        });
        const { nome, descricao } = createCategoriaSchema.parse(req.body);
        try {
            const data = await categoriaUserCase.create({ nome, descricao });
            return reply.send({ message: "Registro realizado com sucesso", data });
        }
        catch (error) {
            reply.status(500).send(error);
        }
    });
    fastify.get('/all', async (req, reply) => {
        try {
            const data = await categoriaUserCase.findAll();
            return reply.send(data);
        }
        catch (error) {
            reply.status(500).send(error);
        }
    });
    fastify.get('/:id', async (req, reply) => {
        const { id } = req.params;
        try {
            const data = await categoriaUserCase.findById(Number(id));
            return reply.send(data);
        }
        catch (error) {
            reply.status(500).send(error);
        }
    });
    fastify.put('/update', { preHandler: auth_middleware_1.authMiddleware }, async (req, reply) => {
        const { id, nome, descricao } = req.body;
        try {
            const data = await categoriaUserCase.update({ id, nome, descricao });
            return reply.send({ message: "Registro atualizado com sucesso", data });
        }
        catch (error) {
            reply.status(500).send(error);
        }
    });
    fastify.delete('/:id', { preHandler: auth_middleware_1.authMiddleware }, async (req, reply) => {
        const { id } = req.params;
        try {
            await categoriaUserCase.delete(Number(id));
            return reply.send({ message: "Registro deletado com sucesso" });
        }
        catch (error) {
            reply.status(500).send(error);
        }
    });
}
;
