import { prisma } from "../database/prisma.client";
import { IUserRepository, IUserWithoutPassword, User } from "../interfaces/user.interface";

class UserRepositoryPrisma implements IUserRepository {
    async findByEmail(email: string): Promise<IUserWithoutPassword | null> {
        const result = await prisma.user.findFirst({
            where: {
                email,
            },
            select: {
                id: true,
                email: true,
                role: true,
                dataCadastro: true,
                cliente: true,
                profissional: true,
                authToken: true,
            },
        });

        return result as IUserWithoutPassword;
    }

    async findById(id: number): Promise<IUserWithoutPassword | null> {
        const result = await prisma.user.findFirst({
            where: {
                id,
            },
            select: {
                id: true,
                email: true,
                role: true,
                dataCadastro: true,
                cliente: true,
                profissional: true,
                authToken: true,
            },
        });

        return result as IUserWithoutPassword;
    }

    async update(data: User): Promise<IUserWithoutPassword> {
        const result = await prisma.user.update({
            where: {
                id: data.id
            },
            data: {
                email: data.email,
                cliente: {
                    update: data.cliente?.map(cliente => ({
                        where: { id: cliente.id },
                        data: {
                            nome: cliente.nome,
                            telefone: cliente.telefone,
                            sexo: cliente.sexo,
                            redeSocial: cliente.redeSocial,
                        }
                    }))
                },
                profissional: {
                    update: data.profissional?.map(profissional => ({
                        where: { id: profissional.id },
                        data: {
                            nome: profissional.nome,
                            telefone: profissional.telefone,
                            cpf: profissional.cpf,
                            saldoCreditos: profissional.saldoCreditos,
                        }
                    }))
                }
            },
            select: {
                id: true,
                email: true,
                role: true,
                dataCadastro: true,
                cliente: true,
                profissional: true,
            }
        });

        return result as IUserWithoutPassword;
    }

    async delete(id: number): Promise<void> {
        await prisma.user.delete({
            where: {
                id
            }
        });
    }
}

export { UserRepositoryPrisma };