"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserRepositoryPrisma = void 0;
const prisma_client_1 = require("../database/prisma.client");
class UserRepositoryPrisma {
    async findByEmail(email) {
        const result = await prisma_client_1.prisma.user.findFirst({
            where: {
                email,
            },
            select: {
                id: true,
                email: true,
                role: true,
                dataCadastro: true,
                cliente: true,
                profissional: true,
                authToken: true,
            },
        });
        return result;
    }
    async findById(id) {
        const result = await prisma_client_1.prisma.user.findFirst({
            where: {
                id,
            },
            select: {
                id: true,
                email: true,
                role: true,
                dataCadastro: true,
                cliente: true,
                profissional: true,
                authToken: true,
            },
        });
        return result;
    }
    async update(data) {
        const result = await prisma_client_1.prisma.user.update({
            where: {
                id: data.id
            },
            data: {
                email: data.email,
                cliente: {
                    update: data.cliente?.map(cliente => ({
                        where: { id: cliente.id },
                        data: {
                            nome: cliente.nome,
                            telefone: cliente.telefone,
                            sexo: cliente.sexo,
                            redeSocial: cliente.redeSocial,
                        }
                    }))
                },
                profissional: {
                    update: data.profissional?.map(profissional => ({
                        where: { id: profissional.id },
                        data: {
                            nome: profissional.nome,
                            telefone: profissional.telefone,
                            cpf: profissional.cpf,
                            saldoCreditos: profissional.saldoCreditos,
                        }
                    }))
                }
            },
            select: {
                id: true,
                email: true,
                role: true,
                dataCadastro: true,
                cliente: true,
                profissional: true,
            }
        });
        return result;
    }
    async delete(id) {
        await prisma_client_1.prisma.user.delete({
            where: {
                id
            }
        });
    }
}
exports.UserRepositoryPrisma = UserRepositoryPrisma;
