import { prisma } from "../database/prisma.client";
import { IPerguntaRepository, Pergunta } from "../interfaces/pergunta.interfaces";

class PerguntaRepositoryPrisma implements IPerguntaRepository {
    async create(data: Pergunta): Promise<Pergunta> {
        const result = await prisma.pergunta.create({
            data: {
                texto: data.texto,
                subcategoria: {
                    connect: { id: data.subcategoria_id }
                }
            }
        });
        return result as never;
    };

    async findAll(): Promise<Pergunta[]> {
        const result = await prisma.pergunta.findMany();
        return result as never;
    };

    async findById(id: number): Promise<Pergunta | null> {
        const numericId = Number(id);

        const result = await prisma.pergunta.findUnique({
            where: {
                id: numericId
            }
        });
        return result as never;

    };
    async update(data: Pergunta): Promise<Pergunta> {
        const result = await prisma.pergunta.update({
            where: { id: data.id },
            data: {
                texto: data.texto,
                subcategoria: {
                    connect: { id: data.subcategoria_id }
                }
            }
        });
        return result as never;
    };

    async delete(id: number): Promise<void> {
        await prisma.pergunta.delete({
            where: { id }
        });
    };
};

export { PerguntaRepositoryPrisma };