"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const prisma_client_1 = require("../database/prisma.client");
class PackRepositoryPrisma {
    async create(data) {
        const result = await prisma_client_1.prisma.pacoteCredito.create({
            data: {
                nome: data.nome,
                quantidadeCreditos: Number(data.quantidadeCreditos),
                valor: data.valor,
                destaque: data.destaque
            }
        });
        return result;
    }
    ;
    async findAll() {
        const result = await prisma_client_1.prisma.pacoteCredito.findMany({
            orderBy: {
                destaque: 'desc'
            }
        });
        return result;
    }
    ;
    async findById(id) {
        const numericId = Number(id);
        const result = await prisma_client_1.prisma.pacoteCredito.findUnique({
            where: {
                id: numericId
            }
        });
        return result;
    }
    ;
    async update(data) {
        const result = await prisma_client_1.prisma.pacoteCredito.update({
            where: {
                id: data.id
            },
            data: {
                nome: data.nome,
                quantidadeCreditos: Number(data.quantidadeCreditos),
                valor: data.valor,
                destaque: data.destaque
            }
        });
        return result;
    }
    ;
    async delete(id) {
        const numericId = Number(id);
        await prisma_client_1.prisma.pacoteCredito.delete({
            where: {
                id: numericId
            }
        });
    }
    ;
}
;
exports.default = PackRepositoryPrisma;
