import { prisma } from "../database/prisma.client";
import { Categoria, ICategoriaRepository } from "../interfaces/categoria.interfaces";


class CategoriaRepositoryPrisma implements ICategoriaRepository {
    async create(data: Categoria): Promise<Categoria> {
        const result = await prisma.categoria.create({
            data: {
                nome: data.nome,
                descricao: data.descricao
            }
        });
        return result as never;
    };

    async findAll(): Promise<Categoria[]> {
        const result = await prisma.categoria.findMany({
            orderBy: {
                id: 'desc'
            }
        });
        return result as never;
    };

    async findById(id: number): Promise<Categoria | null> {
        const numericId = Number(id);

        const result = await prisma.categoria.findUnique({
            where: {
                id: numericId
            }
        });
        return result as never;
    };

    async update(data: Categoria): Promise<Categoria> {
        const result = await prisma.categoria.update({
            where: {
                id: data.id
            },
            data: {
                nome: data.nome,
                descricao: data.descricao
            }
        });
        return result as never;
    };

    async delete(id: number): Promise<void> {
        const numericId = Number(id);

        await prisma.categoria.delete({
            where: {
                id: numericId
            }
        });
    };
}

export default CategoriaRepositoryPrisma;