export interface Categoria {
    id?: number;
    nome: string;
    descricao: string;
};


export interface ICategoriaRepository {
    create(data: Categoria): Promise<Categoria>;
    findAll(): Promise<Categoria[]>;
    findById(id: number): Promise<Categoria | null>;
    update(data: Categoria): Promise<Categoria>;
    delete(id: number): Promise<void>;
}